IF OBJECT_ID('P_EST_MOVIMENTO_VENDAS_TICKETS') IS NOT NULL
	BEGIN
		DROP PROCEDURE P_EST_MOVIMENTO_VENDAS_TICKETS;
	END;
GO
--EXEC P_EST_MOVIMENTO_VENDAS_TICKETS 1,'2017-10-05'
/*
=======================================================================================
'Job.................:  
'Função..............: 
'Objetivo............: Adicionado a origem de venda Ecommerce  
'Tabelas.............: 
'Dt Modificação......: 09/03/2021
'Modificação.........: Tag #A001 ORIG_ORC = 5 --ECOMMERCE

'=======================================================================================
Tag #A001 - Alteração do codigo  
Tag #I001 - Inclusão de novo codigo 
*/

CREATE PROCEDURE [dbo].[P_EST_MOVIMENTO_VENDAS_TICKETS](@CD_EMP  INT, @DT_PROC DATETIME, @CD_FILIAL_PARAM INT,  @PrintDebug Tinyint=0)
AS
	 BEGIN
		 SET NOCOUNT ON;
		 SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED;

/**********************************************************************************************************************************************/

		 DECLARE @CD_CTR_DT_MOVIMENTO INT;
		 DECLARE @SqlText Varchar(8000);

		 PRINT '======================================================TICKET MEDIO ====================================================';
		 PRINT 'Criando movimento de tickets medios.: '+CONVERT(CHAR(10), @DT_PROC, 103) + ' - Time '+CONVERT(VARCHAR(20), GETDATE(), 108);
		 PRINT 'Filial : ' + convert(varchar, @CD_FILIAL_PARAM)
 
		 SELECT
				@CD_CTR_DT_MOVIMENTO = CD_CTR_DT_MOVIMENTO
		 FROM
			 GLB_DT_MOVIMENTO
		 WHERE  DT_MOVIMENTO = @DT_PROC;

/**********************************************************************************************************************************************/
		if @PrintDebug > 0
			 PRINT 'Deletando Tickets movimento anterior - Time '+CONVERT(VARCHAR(20), GETDATE(), 108);

/**********************************************************************************************************************************************/

		set @SqlText = 'DELETE c FROM EST_MOVIMENTO_VENDAS m
						INNER JOIN EST_MOVIMENTO_VENDAS_TICKET_MEDIO_ORIGEM_VENDAS c ON m.CD_CTR_VENDAS = c.CD_CTR_VENDAS
						WHERE
							m.CD_CTR_DT_MOVIMENTO =  '  + CONVERT(VARCHAR, @CD_CTR_DT_MOVIMENTO)+ ' AND m.CD_EMP = 1 AND c.CD_FILIAL = ' + CONVERT(VARCHAR, @CD_FILIAL_PARAM);
		exec (@SqlText);

		set @SqlText = 'DELETE c
						FROM EST_MOVIMENTO_VENDAS m
							INNER JOIN EST_MOVIMENTO_VENDAS_TICKET_MEDIO_ORIGEM_VENDAS_VENDEDOR c ON m.CD_CTR_VENDAS = c.CD_CTR_VENDAS
						WHERE
							m.CD_CTR_DT_MOVIMENTO = '  + CONVERT(VARCHAR, @CD_CTR_DT_MOVIMENTO)+ ' AND m.CD_EMP = 1 AND c.CD_FILIAL = ' + CONVERT(VARCHAR, @CD_FILIAL_PARAM);;
		exec (@SqlText);

		set @SqlText = 'DELETE c
						FROM EST_MOVIMENTO_VENDAS m
							INNER JOIN EST_MOVIMENTO_VENDAS_TICKET_MEDIO_ORIGEM_VENDAS_PRODUTO c ON m.CD_CTR_VENDAS = c.CD_CTR_VENDAS
						WHERE
							m.CD_CTR_DT_MOVIMENTO = '  + CONVERT(VARCHAR, @CD_CTR_DT_MOVIMENTO)+ ' AND m.CD_EMP = 1 AND c.CD_FILIAL = ' + CONVERT(VARCHAR, @CD_FILIAL_PARAM);

		exec (@SqlText);
/**********************************************************************************************************************************************/

	--Ticket medio por origem de vendas
	CREATE TABLE #RsVendasQtdeOrigemVendas
					(CD_EMP              INT
					, CD_FILIAL           INT
					, CD_CTR_DT_MOVIMENTO INT
					, CD_ORIGEM_VENDAS    INT
					, TIPO_VENDA          INT
					, ST_VD               INT
					, QTDE_VENDAS         INT
					);

	--Ticket medio por origem de vendas por vendedor
	CREATE TABLE #RsVendasQtdeOrigemVendasVendedor
				(CD_EMP              INT
					, CD_FILIAL           INT
					, CD_CTR_DT_MOVIMENTO INT
					, CD_ORIGEM_VENDAS    INT
					, CD_VEND             INT
					, TIPO_VENDA          INT
					, ST_VD               INT
					, QTDE_VENDAS         INT
					);

	--Ticket medio por origem de vendas por vendedor
	CREATE TABLE #RsVendasQtdeOrigemVendasProdutos
		(CD_EMP              INT
			, CD_FILIAL           INT
			, CD_CTR_DT_MOVIMENTO INT
			, CD_ORIGEM_VENDAS    INT
			, CD_PROD             INT
			, TIPO_VENDA          INT
			, ST_VD               INT
			, QTDE_VENDAS         INT
			);
			 create table #TELE_ORC_ETAPA_PDV_VD (cd_Vd int,cd_filial int, cd_emp int )
  --truncate table #TELE_ORC_ETAPA_PDV_VD
 
/**********************************************************************************************************************************************/
		if @PrintDebug > 0
		begin
			PRINT 'Gerando a quantidade de vendas - Time '+CONVERT(VARCHAR(20), GETDATE(), 108);
			PRINT 'Vendas qtde cupons fiscais - Time '+CONVERT(VARCHAR(20), GETDATE(), 108);
		end
/**********************************************************************************************************************************************/
------------------------------------------------------------------------------------------------------------------------------------------------------
-- Melhoria de performance
------------------------------------------------------------------------------------------------------------------------------------------------------
	INSERT INTO #TELE_ORC_ETAPA_PDV_VD
       SELECT
              TELE_ORC_ETAPA_PDV_VD.CD_VD
            , TELE_ORC_ETAPA_PDV_VD.CD_FILIAL
            , TELE_ORC_ETAPA_PDV_VD.CD_EMP
       FROM
            PDV_VD AS V
            INNER JOIN TELE_ORC_ETAPA_PDV_VD ON V.CD_VD = TELE_ORC_ETAPA_PDV_VD.CD_VD
                                                AND V.CD_FILIAL = TELE_ORC_ETAPA_PDV_VD.CD_FILIAL
                                                AND V.CD_EMP = TELE_ORC_ETAPA_PDV_VD.CD_EMP
       WHERE V.CD_EMP = @CD_EMP
             AND V.DT_VD = @DT_PROC
			 AND V.CD_FILIAL =@CD_FILIAL_PARAM;
------------------------------------------------------------------------------------------------------------------------------------------------------
-- Tag #A001
		 INSERT INTO                          #RsVendasQtdeOrigemVendas(
				CD_EMP
			  , CD_FILIAL
			  , CD_CTR_DT_MOVIMENTO
			  , CD_ORIGEM_VENDAS
			  , TIPO_VENDA
			  , ST_VD
			  , QTDE_VENDAS)
		 SELECT
				v.CD_EMP
			  , v.CD_FILIAL
			  , @CD_CTR_DT_MOVIMENTO
			  , CASE
					WHEN TELE_ORC_ETAPA_PDV_VD.CD_VD IS NULL THEN CASE
																	  WHEN TLV_PED_VD_PDV_VD.CD_VD IS NULL THEN CASE
																													WHEN V.NR_ORC = 0 THEN 0 --DIRETO P.D.V  
																													ELSE CASE
																															 WHEN isnull(V.ORIG_ORC, 0) = 0 THEN 1 --ORCAMENTO
																															 WHEN V.ORIG_ORC = 1 THEN 2 --TELEVENDAS  
																															 WHEN V.ORIG_ORC = 2 THEN 3 --PBM  
																															 WHEN V.ORIG_ORC = 3 THEN 4 --DRIVE THRU  
																															 WHEN V.ORIG_ORC = 5 THEN 5 --ECOMMERCE
																														 END
																												END
																	  ELSE 2 --TELEVENDAS  
																  END
					ELSE 2 --TELEVENDAS  
				END AS ORIG_VENDA
			  , V.ST_VD AS TIPO_VENDA
			  , V.ST_VD
			  , COUNT(DISTINCT v.CD_VD) AS QTDE_VENDA
		 FROM
			 PDV_VD AS V 
			 LEFT OUTER JOIN #TELE_ORC_ETAPA_PDV_VD TELE_ORC_ETAPA_PDV_VD ON V.CD_VD = TELE_ORC_ETAPA_PDV_VD.CD_VD
													  AND V.CD_FILIAL = TELE_ORC_ETAPA_PDV_VD.CD_FILIAL
													  AND V.CD_EMP = TELE_ORC_ETAPA_PDV_VD.CD_EMP
			 LEFT OUTER JOIN TLV_PED_VD_PDV_VD ON V.CD_VD = TLV_PED_VD_PDV_VD.CD_VD
												  AND V.CD_FILIAL = TLV_PED_VD_PDV_VD.CD_FILIAL_PDV_VD
												  AND V.CD_EMP = TLV_PED_VD_PDV_VD.CD_EMP
		 WHERE  V.CD_EMP = @CD_EMP
				AND V.DT_VD = @DT_PROC
				and V.CD_FILIAL =@CD_FILIAL_PARAM
		 GROUP BY
				  v.CD_EMP
				, v.CD_FILIAL
				, v.ST_VD 
				, TELE_ORC_ETAPA_PDV_VD.CD_VD
				, TLV_PED_VD_PDV_VD.CD_VD
				, V.NR_ORC
				, V.ORIG_ORC;


		 INSERT INTO #RsVendasQtdeOrigemVendasVendedor( CD_EMP
														, CD_FILIAL
														, CD_CTR_DT_MOVIMENTO
														, CD_ORIGEM_VENDAS
														, CD_VEND
														, TIPO_VENDA
														, ST_VD
														, QTDE_VENDAS)
		 SELECT
				v.CD_EMP
			  , v.CD_FILIAL
			  , @CD_CTR_DT_MOVIMENTO CD_CTR_DT_MOVIMENTO
			  , CASE
					WHEN TELE_ORC_ETAPA_PDV_VD.CD_VD IS NULL THEN CASE
																	  WHEN TLV_PED_VD_PDV_VD.CD_VD IS NULL THEN CASE
																													WHEN V.NR_ORC = 0 THEN 0 --DIRETO P.D.V  
																													ELSE CASE
																															 WHEN isnull(V.ORIG_ORC, 0) = 0 THEN 1 --ORCAMENTO
																															 WHEN V.ORIG_ORC = 1 THEN 2 --TELEVENDAS  
																															 WHEN V.ORIG_ORC = 2 THEN 3 --PBM  
																															 WHEN V.ORIG_ORC = 3 THEN 4 --DRIVE THRU 
																															 WHEN V.ORIG_ORC = 5 THEN 5 --ECOMMERCE
																														 END
																												END
																	  ELSE 2 --TELEVENDAS  
																  END
					ELSE 2 --TELEVENDAS  
				END AS ORIG_VENDA
			  , PDV_VD_IT.CD_VEND
			  , V.ST_VD AS TIPO_VENDA
			  , V.ST_VD
			  , COUNT(DISTINCT v.CD_VD) AS QTDE_VENDA
		 FROM
			 PDV_VD AS V
			 INNER JOIN PDV_VD_IT ON V.CD_EMP = PDV_VD_IT.CD_EMP
									 AND V.CD_FILIAL = PDV_VD_IT.CD_FILIAL
									 AND V.CD_VD = PDV_VD_IT.CD_VD
									 AND V.DT_VD = PDV_VD_IT.DT_VD 
			 LEFT OUTER JOIN #TELE_ORC_ETAPA_PDV_VD  TELE_ORC_ETAPA_PDV_VD ON V.CD_VD = TELE_ORC_ETAPA_PDV_VD.CD_VD
													  AND V.CD_FILIAL = TELE_ORC_ETAPA_PDV_VD.CD_FILIAL
													  AND V.CD_EMP = TELE_ORC_ETAPA_PDV_VD.CD_EMP
			 LEFT OUTER JOIN TLV_PED_VD_PDV_VD ON V.CD_VD = TLV_PED_VD_PDV_VD.CD_VD
												  AND V.CD_FILIAL = TLV_PED_VD_PDV_VD.CD_FILIAL_PDV_VD
												  AND V.CD_EMP = TLV_PED_VD_PDV_VD.CD_EMP
		 WHERE  V.CD_EMP = @CD_EMP
				AND V.DT_VD = @DT_PROC
				and V.CD_FILIAL =@CD_FILIAL_PARAM
		 GROUP BY
				  v.CD_EMP
				, v.CD_FILIAL
				, v.ST_VD 
				, TELE_ORC_ETAPA_PDV_VD.CD_VD
				, TLV_PED_VD_PDV_VD.CD_VD
				, V.NR_ORC
				, V.ORIG_ORC
				, PDV_VD_IT.CD_VEND;
				

		 INSERT INTO  #RsVendasQtdeOrigemVendasProdutos( CD_EMP
														, CD_FILIAL
														, CD_CTR_DT_MOVIMENTO
														, CD_ORIGEM_VENDAS
														, CD_PROD
														, TIPO_VENDA
														, ST_VD
														, QTDE_VENDAS)
		 SELECT
				v.CD_EMP
			  , v.CD_FILIAL
			  , @CD_CTR_DT_MOVIMENTO
			  , CASE
					WHEN TELE_ORC_ETAPA_PDV_VD.CD_VD IS NULL THEN CASE
																	  WHEN TLV_PED_VD_PDV_VD.CD_VD IS NULL THEN CASE
																													WHEN V.NR_ORC = 0 THEN 0 --DIRETO P.D.V  
																													ELSE CASE
																															 WHEN isnull(V.ORIG_ORC, 0) = 0 THEN 1 --ORCAMENTO
																															 WHEN V.ORIG_ORC = 1 THEN 2 --TELEVENDAS  
																															 WHEN V.ORIG_ORC = 2 THEN 3 --PBM  
																															 WHEN V.ORIG_ORC = 3 THEN 4 --DRIVE THRU 
																															 WHEN V.ORIG_ORC = 5 THEN 5 --ECOMMERCE
																														 END
																												END
																	  ELSE 2 --TELEVENDAS  
																  END
					ELSE 2 --TELEVENDAS  
				END AS ORIG_VENDA
			  , PDV_VD_IT.CD_PROD
			  , V.ST_VD AS TIPO_VENDA
			  , V.ST_VD
			  , COUNT(DISTINCT v.CD_VD) AS QTDE_VENDA
		 FROM
			 PDV_VD AS V
			 INNER JOIN PDV_VD_IT ON V.CD_EMP = PDV_VD_IT.CD_EMP
									 AND V.CD_FILIAL = PDV_VD_IT.CD_FILIAL
									 AND V.CD_VD = PDV_VD_IT.CD_VD
									 AND V.DT_VD = PDV_VD_IT.DT_VD 
			 LEFT OUTER JOIN #TELE_ORC_ETAPA_PDV_VD TELE_ORC_ETAPA_PDV_VD ON V.CD_VD = TELE_ORC_ETAPA_PDV_VD.CD_VD
													  AND V.CD_FILIAL = TELE_ORC_ETAPA_PDV_VD.CD_FILIAL
													  AND V.CD_EMP = TELE_ORC_ETAPA_PDV_VD.CD_EMP
			 LEFT OUTER JOIN TLV_PED_VD_PDV_VD ON V.CD_VD = TLV_PED_VD_PDV_VD.CD_VD
												  AND V.CD_FILIAL = TLV_PED_VD_PDV_VD.CD_FILIAL_PDV_VD
												  AND V.CD_EMP = TLV_PED_VD_PDV_VD.CD_EMP
		 WHERE  PDV_VD_IT.CD_EMP = @CD_EMP
				AND PDV_VD_IT.DT_VD = @DT_PROC
				and PDV_VD_IT.CD_FILIAL =@CD_FILIAL_PARAM
		 GROUP BY
				  v.CD_EMP
				, v.CD_FILIAL
				, v.ST_VD 
				, TELE_ORC_ETAPA_PDV_VD.CD_VD
				, TLV_PED_VD_PDV_VD.CD_VD
				, V.NR_ORC
				, V.ORIG_ORC
				, PDV_VD_IT.CD_PROD;


/**********************************************************************************************************************************************/
	if @PrintDebug > 0 
		 PRINT 'Vendas qtde cupons nao fiscais - Time '+CONVERT(VARCHAR(20), GETDATE(), 108);    

/**********************************************************************************************************************************************/

		--Por origem de vendas do cupom nao fiscal
		 INSERT INTO #RsVendasQtdeOrigemVendas(
							CD_EMP
						  , CD_FILIAL
						  , CD_CTR_DT_MOVIMENTO
						  , CD_ORIGEM_VENDAS
						  , TIPO_VENDA
						  , ST_VD
						  , QTDE_VENDAS)
		 SELECT
				PDV_CUPOM_NAO_FISCAL.CD_EMP
			  , PDV_CUPOM_NAO_FISCAL.CD_FILIAL
			  , @CD_CTR_DT_MOVIMENTO
			  , 5 AS CD_ORIGEM_VENDAS
			  , 2 AS TIPO_VENDA
			  , 0 AS ST_VD
			  , COUNT(DISTINCT CD_CTR) AS QTDE_VENDA
		 FROM
			 PDV_CUPOM_NAO_FISCAL 
		 WHERE  PDV_CUPOM_NAO_FISCAL.TP_CUPOM_NAO_FISCAL = 3
				AND PDV_CUPOM_NAO_FISCAL.CD_EMP = @CD_EMP
				AND PDV_CUPOM_NAO_FISCAL.DT_CUPOM = @DT_PROC
				AND PDV_CUPOM_NAO_FISCAL.CD_FILIAL =@CD_FILIAL_PARAM
		 GROUP BY
				  PDV_CUPOM_NAO_FISCAL.CD_EMP
				, PDV_CUPOM_NAO_FISCAL.CD_FILIAL ;

		--Por origem de vendas do cupom nao fiscal
		 INSERT INTO   #RsVendasQtdeOrigemVendasVendedor( CD_EMP
														, CD_FILIAL
														, CD_CTR_DT_MOVIMENTO
														, CD_ORIGEM_VENDAS
														, CD_VEND
														, TIPO_VENDA
														, ST_VD
														, QTDE_VENDAS)
		 SELECT
				PDV_CUPOM_NAO_FISCAL.CD_EMP
			  , PDV_CUPOM_NAO_FISCAL.CD_FILIAL
			  , @CD_CTR_DT_MOVIMENTO
			  , 5 AS CD_ORIGEM_VENDAS
			  , FP_FUNC.CD_FUN
			  , 2 AS TIPO_VENDA
			  , 0 AS ST_VD
			  , COUNT(DISTINCT CD_CTR) AS QTDE_VENDA
		 FROM
			 PDV_CUPOM_NAO_FISCAL 
			 INNER JOIN FP_FUNC ON PDV_CUPOM_NAO_FISCAL.CD_USU = FP_FUNC.CD_FUNC_USU
		 WHERE  PDV_CUPOM_NAO_FISCAL.TP_CUPOM_NAO_FISCAL = 3
				AND PDV_CUPOM_NAO_FISCAL.CD_EMP = @CD_EMP
				AND PDV_CUPOM_NAO_FISCAL.DT_CUPOM = @DT_PROC
				AND PDV_CUPOM_NAO_FISCAL.CD_FILIAL =@CD_FILIAL_PARAM
		 GROUP BY
				  PDV_CUPOM_NAO_FISCAL.CD_EMP
				, PDV_CUPOM_NAO_FISCAL.CD_FILIAL 
				, FP_FUNC.CD_FUN;

		--Por origem de vendas do cupom nao fiscal
		 INSERT INTO #RsVendasQtdeOrigemVendasProdutos(
														CD_EMP
													  , CD_FILIAL
													  , CD_CTR_DT_MOVIMENTO
													  , CD_ORIGEM_VENDAS
													  , CD_PROD
													  , TIPO_VENDA
													  , ST_VD
													  , QTDE_VENDAS)
		 SELECT
				PDV_CUPOM_NAO_FISCAL.CD_EMP
			  , PDV_CUPOM_NAO_FISCAL.CD_FILIAL
			  , @CD_CTR_DT_MOVIMENTO CD_CTR_DT_MOVIMENTO
			  , 5 AS CD_ORIGEM_VENDAS
			  , 0 AS CD_PROD
			  , 2 AS TIPO_VENDA
			  , 0 AS ST_VD
			  , COUNT(DISTINCT CD_CTR) AS QTDE_VENDA
		 FROM
			 PDV_CUPOM_NAO_FISCAL 
			 INNER JOIN FP_FUNC ON PDV_CUPOM_NAO_FISCAL.CD_USU = FP_FUNC.CD_FUNC_USU
		 WHERE  PDV_CUPOM_NAO_FISCAL.TP_CUPOM_NAO_FISCAL = 3
				AND PDV_CUPOM_NAO_FISCAL.CD_EMP = @CD_EMP
				AND PDV_CUPOM_NAO_FISCAL.DT_CUPOM = @DT_PROC
				AND PDV_CUPOM_NAO_FISCAL.CD_FILIAL =@CD_FILIAL_PARAM
		 GROUP BY
				  PDV_CUPOM_NAO_FISCAL.CD_EMP
				, PDV_CUPOM_NAO_FISCAL.CD_FILIAL 
				, FP_FUNC.CD_FUN;

/**********************************************************************************************************************************************/
	if @PrintDebug > 0 
		 PRINT 'Vendas qtde devolucoes - Time '+CONVERT(VARCHAR(20), GETDATE(), 108);

/**********************************************************************************************************************************************/

--Por origem de devolucao de vendas
		 INSERT INTO                          #RsVendasQtdeOrigemVendas(
				CD_EMP
			  , CD_FILIAL
			  , CD_CTR_DT_MOVIMENTO
			  , CD_ORIGEM_VENDAS
			  , TIPO_VENDA
			  , ST_VD
			  , QTDE_VENDAS)
		 SELECT
				PDV_VD_DEV_EST_PROD_IMP.CD_EMP
			  , PDV_VD_DEV_EST_PROD_IMP.CD_FILIAL
			  , @CD_CTR_DT_MOVIMENTO CD_CTR_DT_MOVIMENTO
			  , 6 AS CD_ORIGEM_VENDAS
			  , 3 AS TIPO_VENDA
			  , 0 AS ST_VD
			  , COUNT(DISTINCT PDV_VD.CD_VD) * -1 AS QTDE_VENDA
		 FROM
			 PDV_VD_DEV_EST_PROD_IMP
			 INNER JOIN PDV_VD ON PDV_VD_DEV_EST_PROD_IMP.CD_EMP = PDV_VD.CD_EMP
								  AND PDV_VD_DEV_EST_PROD_IMP.CD_FILIAL = PDV_VD.CD_FILIAL
								  AND PDV_VD_DEV_EST_PROD_IMP.CD_VD = PDV_VD.CD_VD 
		 WHERE  PDV_VD_DEV_EST_PROD_IMP.CD_EMP = @CD_EMP
				AND PDV_VD_DEV_EST_PROD_IMP.DT_DEVO = @DT_PROC
				AND PDV_VD_DEV_EST_PROD_IMP.CD_FILIAL =@CD_FILIAL_PARAM
		 GROUP BY
				  PDV_VD_DEV_EST_PROD_IMP.CD_EMP
				, PDV_VD_DEV_EST_PROD_IMP.CD_FILIAL ;

		--Por origem de devolucao de vendas
		 INSERT INTO #RsVendasQtdeOrigemVendasVendedor(CD_EMP
														  , CD_FILIAL
														  , CD_CTR_DT_MOVIMENTO
														  , CD_ORIGEM_VENDAS
														  , CD_VEND
														  , TIPO_VENDA
														  , ST_VD
														  , QTDE_VENDAS)
		 SELECT
				PDV_VD_DEV_EST_PROD_IMP.CD_EMP
			  , PDV_VD_DEV_EST_PROD_IMP.CD_FILIAL
			  , @CD_CTR_DT_MOVIMENTO CD_CTR_DT_MOVIMENTO
			  , 6 AS CD_ORIGEM_VENDAS
			  , PDV_VD_DEV_EST_PROD_IMP.CD_VEND
			  , 3 AS TIPO_VENDA
			  , 0 AS ST_VD
			  , COUNT(DISTINCT PDV_VD.CD_VD) * -1 AS QTDE_VENDA
		 FROM
			 PDV_VD_DEV_EST_PROD_IMP
			 INNER JOIN PDV_VD ON PDV_VD_DEV_EST_PROD_IMP.CD_EMP = PDV_VD.CD_EMP
								  AND PDV_VD_DEV_EST_PROD_IMP.CD_FILIAL = PDV_VD.CD_FILIAL
								  AND PDV_VD_DEV_EST_PROD_IMP.CD_VD = PDV_VD.CD_VD 
		 WHERE  PDV_VD_DEV_EST_PROD_IMP.CD_EMP = @CD_EMP
				AND PDV_VD_DEV_EST_PROD_IMP.DT_DEVO = @DT_PROC
				AND PDV_VD_DEV_EST_PROD_IMP.CD_FILIAL =@CD_FILIAL_PARAM
		 GROUP BY
				  PDV_VD_DEV_EST_PROD_IMP.CD_EMP
				, PDV_VD_DEV_EST_PROD_IMP.CD_FILIAL 
				, PDV_VD_DEV_EST_PROD_IMP.CD_VEND;

		--Por origem de devolucao de vendas
		 INSERT INTO #RsVendasQtdeOrigemVendasProdutos(
				CD_EMP
			  , CD_FILIAL
			  , CD_CTR_DT_MOVIMENTO
			  , CD_ORIGEM_VENDAS
			  , CD_PROD
			  , TIPO_VENDA
			  , ST_VD
			  , QTDE_VENDAS)
		 SELECT
				PDV_VD_DEV_EST_PROD_IMP.CD_EMP
			  , PDV_VD_DEV_EST_PROD_IMP.CD_FILIAL
			  , @CD_CTR_DT_MOVIMENTO CD_CTR_DT_MOVIMENTO
			  , 6 AS CD_ORIGEM_VENDAS
			  , PDV_VD_DEV_EST_PROD_IMP.CD_PROD
			  , 3 AS TIPO_VENDA
			  , 0 AS ST_VD
			  , COUNT(DISTINCT PDV_VD.CD_VD) * -1 AS QTDE_VENDA
		 FROM
			 PDV_VD_DEV_EST_PROD_IMP
			 INNER JOIN PDV_VD ON PDV_VD_DEV_EST_PROD_IMP.CD_EMP = PDV_VD.CD_EMP
								  AND PDV_VD_DEV_EST_PROD_IMP.CD_FILIAL = PDV_VD.CD_FILIAL
								  AND PDV_VD_DEV_EST_PROD_IMP.CD_VD = PDV_VD.CD_VD 
		 WHERE  PDV_VD_DEV_EST_PROD_IMP.CD_EMP = @CD_EMP
				AND PDV_VD_DEV_EST_PROD_IMP.DT_DEVO = @DT_PROC
				AND PDV_VD_DEV_EST_PROD_IMP.CD_FILIAL =@CD_FILIAL_PARAM
		 GROUP BY
				  PDV_VD_DEV_EST_PROD_IMP.CD_EMP
				, PDV_VD_DEV_EST_PROD_IMP.CD_FILIAL 
				, PDV_VD_DEV_EST_PROD_IMP.CD_PROD;

/**********************************************************************************************************************************************/
	if @PrintDebug > 0 
		 PRINT 'Vendas qtde notas fiscais - Time '+CONVERT(VARCHAR(20), GETDATE(), 108);

/**********************************************************************************************************************************************/

--Por origem de nota fiscal
		 INSERT INTO                          #RsVendasQtdeOrigemVendas(
				CD_EMP
			  , CD_FILIAL
			  , CD_CTR_DT_MOVIMENTO
			  , CD_ORIGEM_VENDAS
			  , TIPO_VENDA
			  , ST_VD
			  , QTDE_VENDAS)
		 SELECT
				EST_NF_SAI.CD_EMP
			  , EST_NF_SAI.CD_FILIAL
			  , @CD_CTR_DT_MOVIMENTO CD_CTR_DT_MOVIMENTO
			  , 7 AS CD_ORIGEM_VENDAS
			  , 10 AS TIPO_VENDA
			  , 0 AS ST_VD
			  , COUNT(DISTINCT EST_NF_SAI.CD_NF) AS QTDE_VENDA
		 FROM
			 EST_NF_SAI 
			 INNER JOIN EST_NF_SAI_VENDAS ON EST_NF_SAI.CD_EMP = EST_NF_SAI_VENDAS.CD_EMP
											 AND EST_NF_SAI.CD_FILIAL = EST_NF_SAI_VENDAS.CD_FILIAL
											 AND EST_NF_SAI.CD_NF = EST_NF_SAI_VENDAS.CD_NF
		 WHERE  EST_NF_SAI.CD_EMP = @CD_EMP
				AND EST_NF_SAI.DT_EMI_NF = @DT_PROC
				AND EST_NF_SAI.STS_NF = 0
				AND EST_NF_SAI.CD_FILIAL =@CD_FILIAL_PARAM
		 GROUP BY
				  EST_NF_SAI.CD_EMP
				, EST_NF_SAI.CD_FILIAL ;

 --Por origem de nota fiscal
		 INSERT INTO                                  #RsVendasQtdeOrigemVendasVendedor(
				CD_EMP
			  , CD_FILIAL
			  , CD_CTR_DT_MOVIMENTO
			  , CD_ORIGEM_VENDAS
			  , CD_VEND
			  , TIPO_VENDA
			  , ST_VD
			  , QTDE_VENDAS)
		 SELECT
				EST_NF_SAI.CD_EMP
			  , EST_NF_SAI.CD_FILIAL
			  , @CD_CTR_DT_MOVIMENTO CD_CTR_DT_MOVIMENTO
			  , 7 AS CD_ORIGEM_VENDAS
			  , EST_NF_SAI.CD_VEND
			  , 10 AS TIPO_VENDA
			  , 0 AS ST_VD
			  , COUNT(DISTINCT EST_NF_SAI.CD_NF) AS QTDE_VENDA
		 FROM
			 EST_NF_SAI
			 INNER JOIN GLB_DT_MOVIMENTO ON EST_NF_SAI.DT_EMI_NF = GLB_DT_MOVIMENTO.DT_MOVIMENTO
			 INNER JOIN EST_NF_SAI_VENDAS ON EST_NF_SAI.CD_EMP = EST_NF_SAI_VENDAS.CD_EMP
											 AND EST_NF_SAI.CD_FILIAL = EST_NF_SAI_VENDAS.CD_FILIAL
											 AND EST_NF_SAI.CD_NF = EST_NF_SAI_VENDAS.CD_NF
		 WHERE  EST_NF_SAI.CD_EMP = @CD_EMP
				AND EST_NF_SAI.DT_EMI_NF = @DT_PROC
				AND EST_NF_SAI.STS_NF = 0
				AND EST_NF_SAI.CD_FILIAL =@CD_FILIAL_PARAM
		 GROUP BY
				  EST_NF_SAI.CD_EMP
				, EST_NF_SAI.CD_FILIAL 
				, EST_NF_SAI.CD_VEND;

--Por origem de nota fiscal
		 INSERT INTO                                  #RsVendasQtdeOrigemVendasProdutos(
				CD_EMP
			  , CD_FILIAL
			  , CD_CTR_DT_MOVIMENTO
			  , CD_ORIGEM_VENDAS
			  , CD_PROD
			  , TIPO_VENDA
			  , ST_VD
			  , QTDE_VENDAS)
		 SELECT
				EST_NF_SAI.CD_EMP
			  , EST_NF_SAI.CD_FILIAL
			  , @CD_CTR_DT_MOVIMENTO CD_CTR_DT_MOVIMENTO
			  , 7 AS CD_ORIGEM_VENDAS
			  , EST_NF_SAI_IT.CD_PROD
			  , 10 AS TIPO_VENDA
			  , 0 AS ST_VD
			  , COUNT(DISTINCT EST_NF_SAI.CD_NF) AS QTDE_VENDA
		 FROM
			 EST_NF_SAI
		 
			 INNER JOIN EST_NF_SAI_VENDAS ON EST_NF_SAI.CD_EMP = EST_NF_SAI_VENDAS.CD_EMP
											 AND EST_NF_SAI.CD_FILIAL = EST_NF_SAI_VENDAS.CD_FILIAL
											 AND EST_NF_SAI.CD_NF = EST_NF_SAI_VENDAS.CD_NF
			 INNER JOIN EST_NF_SAI_IT ON EST_NF_SAI.CD_EMP = EST_NF_SAI_IT.CD_EMP
										 AND EST_NF_SAI.CD_FILIAL = EST_NF_SAI_IT.CD_FILIAL
										 AND EST_NF_SAI.CD_NF = EST_NF_SAI_IT.CD_NF
		 WHERE  EST_NF_SAI.CD_EMP = @CD_EMP
				AND EST_NF_SAI.DT_EMI_NF = @DT_PROC
				AND EST_NF_SAI.STS_NF = 0
				AND EST_NF_SAI.CD_FILIAL =@CD_FILIAL_PARAM
		 GROUP BY
				  EST_NF_SAI.CD_EMP
				, EST_NF_SAI.CD_FILIAL 
				, EST_NF_SAI_IT.CD_PROD;

/**********************************************************************************************************************************************/
	if @PrintDebug > 0 
		 PRINT 'Devolucoes qtde nota fiscal - Time '+CONVERT(VARCHAR(20), GETDATE(), 108);

/**********************************************************************************************************************************************/

--Por origem de devolucao de vendas
		 INSERT INTO                          #RsVendasQtdeOrigemVendas(
				CD_EMP
			  , CD_FILIAL
			  , CD_CTR_DT_MOVIMENTO
			  , CD_ORIGEM_VENDAS
			  , TIPO_VENDA
			  , ST_VD
			  , QTDE_VENDAS)
		 SELECT
				V_EST_NF_SAI_VENDAS_DEVOLUCAO.CD_EMP
			  , V_EST_NF_SAI_VENDAS_DEVOLUCAO.CD_FILIAL
			  , @CD_CTR_DT_MOVIMENTO CD_CTR_DT_MOVIMENTO
			  , 8 AS CD_ORIGEM_VENDAS
			  , 11 AS TIPO_VENDA
			  , 0 AS ST_VD
			  , COUNT(DISTINCT V_EST_NF_SAI_VENDAS_DEVOLUCAO.CD_NF) * -1 AS QTDE_VENDA
		 FROM
			 V_EST_NF_SAI_VENDAS_DEVOLUCAO 
		 WHERE  V_EST_NF_SAI_VENDAS_DEVOLUCAO.CD_EMP = @CD_EMP
				AND V_EST_NF_SAI_VENDAS_DEVOLUCAO.DT_DEVO = @DT_PROC
				AND V_EST_NF_SAI_VENDAS_DEVOLUCAO.CD_FILIAL =@CD_FILIAL_PARAM
		 GROUP BY
				  V_EST_NF_SAI_VENDAS_DEVOLUCAO.CD_EMP
				, V_EST_NF_SAI_VENDAS_DEVOLUCAO.CD_FILIAL ;

--Por origem de devolucao de vendas
		 INSERT INTO                                  #RsVendasQtdeOrigemVendasVendedor(
				CD_EMP
			  , CD_FILIAL
			  , CD_CTR_DT_MOVIMENTO
			  , CD_ORIGEM_VENDAS
			  , CD_VEND
			  , TIPO_VENDA
			  , ST_VD
			  , QTDE_VENDAS)
		 SELECT
				V_EST_NF_SAI_VENDAS_DEVOLUCAO.CD_EMP
			  , V_EST_NF_SAI_VENDAS_DEVOLUCAO.CD_FILIAL
			  , @CD_CTR_DT_MOVIMENTO CD_CTR_DT_MOVIMENTO
			  , 8 AS CD_ORIGEM_VENDAS
			  , V_EST_NF_SAI_VENDAS_DEVOLUCAO.CD_VEND
			  , 11 AS TIPO_VENDA
			  , 0 AS ST_VD
			  , COUNT(DISTINCT V_EST_NF_SAI_VENDAS_DEVOLUCAO.CD_NF) * -1 AS QTDE_VENDA
		 FROM
			 V_EST_NF_SAI_VENDAS_DEVOLUCAO 
		 WHERE  V_EST_NF_SAI_VENDAS_DEVOLUCAO.CD_EMP = @CD_EMP
				AND V_EST_NF_SAI_VENDAS_DEVOLUCAO.DT_DEVO = @DT_PROC
				AND V_EST_NF_SAI_VENDAS_DEVOLUCAO.CD_FILIAL =@CD_FILIAL_PARAM
		 GROUP BY
				  V_EST_NF_SAI_VENDAS_DEVOLUCAO.CD_EMP
				, V_EST_NF_SAI_VENDAS_DEVOLUCAO.CD_FILIAL 
				, V_EST_NF_SAI_VENDAS_DEVOLUCAO.CD_VEND;

--Por origem de devolucao de vendas
		 INSERT INTO #RsVendasQtdeOrigemVendasProdutos(
									CD_EMP
								  , CD_FILIAL
								  , CD_CTR_DT_MOVIMENTO
								  , CD_ORIGEM_VENDAS
								  , CD_PROD
								  , TIPO_VENDA
								  , ST_VD
								  , QTDE_VENDAS)
		 SELECT
				V_EST_NF_SAI_VENDAS_DEVOLUCAO.CD_EMP
			  , V_EST_NF_SAI_VENDAS_DEVOLUCAO.CD_FILIAL
			  , @CD_CTR_DT_MOVIMENTO CD_CTR_DT_MOVIMENTO
			  , 8 AS CD_ORIGEM_VENDAS
			  , V_EST_NF_SAI_VENDAS_DEVOLUCAO.CD_PROD
			  , 11 AS TIPO_VENDA
			  , 0 AS ST_VD
			  , COUNT(DISTINCT V_EST_NF_SAI_VENDAS_DEVOLUCAO.CD_NF) * -1 AS QTDE_VENDA
		 FROM
			 V_EST_NF_SAI_VENDAS_DEVOLUCAO 
		 WHERE  V_EST_NF_SAI_VENDAS_DEVOLUCAO.CD_EMP = @CD_EMP
				AND V_EST_NF_SAI_VENDAS_DEVOLUCAO.DT_DEVO = @DT_PROC
				AND V_EST_NF_SAI_VENDAS_DEVOLUCAO.CD_FILIAL =@CD_FILIAL_PARAM
		 GROUP BY
				  V_EST_NF_SAI_VENDAS_DEVOLUCAO.CD_EMP
				, V_EST_NF_SAI_VENDAS_DEVOLUCAO.CD_FILIAL 
				, V_EST_NF_SAI_VENDAS_DEVOLUCAO.CD_PROD;

	if @PrintDebug > 0 
		 PRINT 'Gravando vendas do dia por origem venda - Time '+CONVERT(VARCHAR(20), GETDATE(), 108);


		 INSERT INTO   EST_MOVIMENTO_VENDAS_TICKET_MEDIO_ORIGEM_VENDAS(
				CD_CTR_VENDAS
			  , CD_CTR_DT_MOVIMENTO
			  , CD_ORIGEM_VENDA
			  , CD_EMP
			  , CD_FILIAL
			  , QTDE_VD
			  , DT_CAD)
		 SELECT
				EST_MOVIMENTO_VENDAS.CD_CTR_VENDAS
			  , v.CD_CTR_DT_MOVIMENTO
			  , V.CD_ORIGEM_VENDAS
			  , v.CD_EMP
			  , v.CD_FILIAL
			  , SUM(v.QTDE_VENDAS) AS QT_VD
			  , GETDATE()
		 FROM
			 #RsVendasQtdeOrigemVendas v
			 INNER JOIN EST_MOVIMENTO_VENDAS ON V.CD_CTR_DT_MOVIMENTO = EST_MOVIMENTO_VENDAS.CD_CTR_DT_MOVIMENTO
												AND V.CD_EMP = EST_MOVIMENTO_VENDAS.CD_EMP
												AND V.CD_FILIAL = EST_MOVIMENTO_VENDAS.CD_FILIAL
												AND V.TIPO_VENDA = EST_MOVIMENTO_VENDAS.TIPO_VENDA
		WHERE  EST_MOVIMENTO_VENDAS.CD_EMP = @CD_EMP
				AND EST_MOVIMENTO_VENDAS.CD_FILIAL =@CD_FILIAL_PARAM
		GROUP BY
				  EST_MOVIMENTO_VENDAS.CD_CTR_VENDAS
				, v.CD_CTR_DT_MOVIMENTO
				, v.CD_EMP
				, v.CD_FILIAL
				, v.TIPO_VENDA
				, V.CD_ORIGEM_VENDAS;

	if @PrintDebug > 0 
		 PRINT 'Gravando vendas do dia vendedor - Time '+CONVERT(VARCHAR(20), GETDATE(), 108);

		 INSERT INTO                                                         EST_MOVIMENTO_VENDAS_TICKET_MEDIO_ORIGEM_VENDAS_VENDEDOR(
				CD_CTR_VENDAS
			  , CD_CTR_DT_MOVIMENTO
			  , CD_ORIGEM_VENDA
			  , CD_VEND
			  , CD_EMP
			  , CD_FILIAL
			  , QTDE_VD
			  , DT_CAD)
		 SELECT
				EST_MOVIMENTO_VENDAS.CD_CTR_VENDAS
			  , v.CD_CTR_DT_MOVIMENTO
			  , V.CD_ORIGEM_VENDAS
			  , V.CD_VEND
			  , v.CD_EMP
			  , v.CD_FILIAL
			  , SUM(v.QTDE_VENDAS) AS QT_VD
			  , GETDATE()
		 FROM
			 #RsVendasQtdeOrigemVendasVendedor v
			 INNER JOIN EST_MOVIMENTO_VENDAS ON V.CD_CTR_DT_MOVIMENTO = EST_MOVIMENTO_VENDAS.CD_CTR_DT_MOVIMENTO
												AND V.CD_EMP = EST_MOVIMENTO_VENDAS.CD_EMP
												AND V.CD_FILIAL = EST_MOVIMENTO_VENDAS.CD_FILIAL
												AND V.TIPO_VENDA = EST_MOVIMENTO_VENDAS.TIPO_VENDA
		 WHERE  EST_MOVIMENTO_VENDAS.CD_EMP = @CD_EMP
				AND EST_MOVIMENTO_VENDAS.CD_FILIAL =@CD_FILIAL_PARAM
		 GROUP BY
				  EST_MOVIMENTO_VENDAS.CD_CTR_VENDAS
				, v.CD_CTR_DT_MOVIMENTO
				, v.CD_EMP
				, v.CD_FILIAL
				, v.TIPO_VENDA
				, V.CD_ORIGEM_VENDAS
				, V.CD_VEND;

	if @PrintDebug > 0 			
		 PRINT 'Gravando vendas do dia produtos - Time '+CONVERT(VARCHAR(20), GETDATE(), 108);

		 INSERT INTO                                                        EST_MOVIMENTO_VENDAS_TICKET_MEDIO_ORIGEM_VENDAS_PRODUTO(
				CD_CTR_VENDAS
			  , CD_CTR_DT_MOVIMENTO
			  , CD_ORIGEM_VENDA
			  , CD_PROD
			  , CD_EMP
			  , CD_FILIAL
			  , QTDE_VD
			  , DT_CAD)
		 SELECT
				EST_MOVIMENTO_VENDAS.CD_CTR_VENDAS
			  , v.CD_CTR_DT_MOVIMENTO
			  , V.CD_ORIGEM_VENDAS
			  , V.CD_PROD
			  , v.CD_EMP
			  , v.CD_FILIAL
			  , SUM(v.QTDE_VENDAS) AS QT_VD
			  , GETDATE()
		 FROM
			 #RsVendasQtdeOrigemVendasProdutos v
			 INNER JOIN EST_MOVIMENTO_VENDAS ON V.CD_CTR_DT_MOVIMENTO = EST_MOVIMENTO_VENDAS.CD_CTR_DT_MOVIMENTO
												AND V.CD_EMP = EST_MOVIMENTO_VENDAS.CD_EMP
												AND V.CD_FILIAL = EST_MOVIMENTO_VENDAS.CD_FILIAL
												AND V.TIPO_VENDA = EST_MOVIMENTO_VENDAS.TIPO_VENDA
		WHERE  EST_MOVIMENTO_VENDAS.CD_EMP = @CD_EMP
				AND EST_MOVIMENTO_VENDAS.CD_FILIAL =@CD_FILIAL_PARAM
		GROUP BY
				  EST_MOVIMENTO_VENDAS.CD_CTR_VENDAS
				, v.CD_CTR_DT_MOVIMENTO
				, v.CD_EMP
				, v.CD_FILIAL
				, v.TIPO_VENDA
				, V.CD_ORIGEM_VENDAS
				, V.CD_PROD;

/**********************************************************************************************************************************************/

		 DROP TABLE #RsVendasQtdeOrigemVendas;
		 DROP TABLE #RsVendasQtdeOrigemVendasVendedor;
		 DROP TABLE #RsVendasQtdeOrigemVendasProdutos;

/**********************************************************************************************************************************************/

		 PRINT '======================================================FIM TICKET MEDIO ====================================================';
	 END;